<?php
require_once __DIR__ . "/../vendor/autoload.php";
require_once __DIR__ . "/../config/jwt.php";

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function create_jwt($user_id) {
    $issuedAt = time();
    $expire = $issuedAt + JWT_EXPIRATION;

    $payload = [
        "iss" => "quiz-app",   // emissor
        "iat" => $issuedAt,    // emitido em
        "exp" => $expire,      // expira em
        "uid" => $user_id      // id do usuário
    ];

    return JWT::encode($payload, JWT_SECRET_KEY, 'HS256');
}


function verify_jwt($token) {
    try {
        $decoded = JWT::decode($token, new Key(JWT_SECRET_KEY, 'HS256'));
        return (array)$decoded;
    } catch (Exception $e) {
        return false;
    }
}
