<?php
require_once __DIR__ . "/jwt_helper.php"; 

/**
 * require_auth($optional = false)
 * - se optional=false: exige token no header Authorization: Bearer <token>, retorna user_id, ou encerra (401)
 * - se optional=true/false respectivamente: retorna user_id ou null
 */
function require_auth($optional = false) {
    // obter header Authorization de forma compatível
    $headers = null;
    if (function_exists('getallheaders')) {
        $headers = getallheaders();
    } else {
        // fallback
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            if (substr($name, 0, 5) === 'HTTP_') {
                $h = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
                $headers[$h] = $value;
            }
        }
    }

    $auth = $headers['Authorization'] ?? $headers['authorization'] ?? '';

    if (!$auth) {
        if ($optional) return null;
        http_response_code(401);
        echo json_encode(["success" => false, "message" => "Token ausente"]);
        exit;
    }

    if (!preg_match('/^Bearer\s+(.*)$/i', $auth, $m)) {
        if ($optional) return null;
        http_response_code(401);
        echo json_encode(["success" => false, "message" => "Formato de Authorization inválido"]);
        exit;
    }

    $token = trim($m[1]);
    $payload = verify_jwt($token);
    if (!$payload) {
        if ($optional) return null;
        http_response_code(401);
        echo json_encode(["success" => false, "message" => "Token inválido ou expirado"]);
        exit;
    }

    // payload é um array (como no seu verify_jwt)
    if (!isset($payload['uid'])) {
        if ($optional) return null;
        http_response_code(401);
        echo json_encode(["success" => false, "message" => "Token inválido"]);
        exit;
    }

    return intval($payload['uid']);
}
