<?php
header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/auth_middleware.php";

// Pega o usuário autenticado
$user_id = require_auth(); // retorna o ID do usuário ou encerra com 401

// Dados da compra enviados via POST
$platform = isset($_POST['platform']) ? trim($_POST['platform']) : "";
$purchase_token = isset($_POST['purchase_token']) ? trim($_POST['purchase_token']) : "";

if (!$platform || !$purchase_token) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Parâmetros inválidos"]);
    exit;
}

try {
    // 1. Verifica se o usuário existe (garantido pelo JWT, mas checagem extra não faz mal)
    $stmt = $pdo->prepare("SELECT id FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        echo json_encode(["success" => false, "message" => "Usuário não encontrado"]);
        exit;
    }

    // 2. Simulação de verificação de compra
    // Aqui no futuro integra com Google/Apple
    $isValid = false;
    if (strlen($purchase_token) > 10) {
        $isValid = true;
    }

    if (!$isValid) {
        http_response_code(400);
        echo json_encode(["success" => false, "message" => "Compra inválida"]);
        exit;
    }

    // 3. Atualiza plano do usuário (upgrade para premium)
    $stmt = $pdo->prepare("UPDATE users SET plan_id = ? WHERE id = ?");
    $stmt->execute([2, $user_id]); // plano 2 = Premium

    echo json_encode([
        "success" => true,
        "message" => "Compra validada com sucesso",
        "new_plan_id" => 2
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Erro no servidor: " . $e->getMessage()]);
    exit;
}
