<?php
header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/auth_middleware.php";

// Autenticação via JWT
$user_id = require_auth(); // retorna o ID do usuário autenticado ou encerra com 401

try {
    $stmt = $pdo->prepare("
        SELECT u.id, u.username, u.score, u.current_group, u.answered, 
               u.daily_answered, u.last_answer_date, p.daily_limit
        FROM users u
        JOIN plans p ON u.plan_id = p.id
        WHERE u.id = ?
    ");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(404);
        echo json_encode(["success" => false, "message" => "Usuário não encontrado"]);
        exit;
    }

    // Reset diário
    $today = gmdate('Y-m-d');
    if ($user['last_answer_date'] === null || $user['last_answer_date'] !== $today) {
        $user['daily_answered'] = 0;
        // atualiza banco
        $upd = $pdo->prepare("UPDATE users SET daily_answered = 0, last_answer_date = ? WHERE id = ?");
        $upd->execute([$today, $user_id]);
    }


    // Helpers
    $stmt = $pdo->prepare("SELECT fifty_used, reveal_used FROM user_helpers WHERE user_id = ? LIMIT 1");
    $stmt->execute([$user_id]);
    $helpers = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$helpers) {
        $pdo->prepare("INSERT INTO user_helpers (user_id, fifty_used, reveal_used) VALUES (?, 0, 0)")
            ->execute([$user_id]);
        $helpers = ["fifty_used" => 0, "reveal_used" => 0];
    }


    // Configurações fixas do jogo
    $total_groups = 5;
    $questions_per_group = 4;
    $total_questions = $total_groups * $questions_per_group;

    // Verificar conclusão
    $finished = ($user["current_group"] > $total_groups);

    echo json_encode([
        "success" => true,
        "user_id" => $user["id"],
        "username" => $user["username"],
        "score" => intval($user["score"]),
        "current_group" => intval($user["current_group"]),
        "total_groups" => $total_groups,
        "answered_total" => intval($user["answered"]),
        "total_questions" => $total_questions,
        "daily_answered" => intval($user["daily_answered"]),
        "daily_limit" => intval($user["daily_limit"]),
        "helpers" => [
            "fifty_fifty_available" => $helpers["fifty_used"] == 0,
            "reveal_available" => $helpers["reveal_used"] == 0
        ],
        "finished" => $finished
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Erro no servidor: " . $e->getMessage()]);
    exit;
}
