<?php
header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/auth_middleware.php";

// Requer login
$user_id = require_auth();

try {
    $pdo->beginTransaction();

    // Verifica se o usuário existe
    $stmt = $pdo->prepare("SELECT id FROM users WHERE id = ? FOR UPDATE");
    $stmt->execute([$user_id]);
    if (!$stmt->fetch()) {
        $pdo->rollBack();
        http_response_code(404);
        echo json_encode(["success" => false, "message" => "Usuário não encontrado"]);
        exit;
    }

    // Reset do progresso do usuário
    $resetUser = $pdo->prepare("
        UPDATE users
        SET current_group = 1,
            score = 0,
            answered = 0,
            daily_answered = 0,
            last_answer_date = NULL
        WHERE id = ?
    ");
    $resetUser->execute([$user_id]);

    // Reset helpers
    $resetHelpers = $pdo->prepare("
        UPDATE user_helpers
        SET fifty_used = 0,
            reveal_used = 0
        WHERE user_id = ?
    ");
    $resetHelpers->execute([$user_id]);

    // Opcional: deletar tentativas do usuário
    $deleteAttempts = $pdo->prepare("DELETE FROM attempts WHERE user_id = ?");
    $deleteAttempts->execute([$user_id]);

    $pdo->commit();

    echo json_encode([
        "success" => true,
        "message" => "Progresso do jogo reiniciado com sucesso",
        "user_id" => $user_id
    ]);

} catch (PDOException $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Erro no servidor: " . $e->getMessage()]);
    exit;
}
