<?php
header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/jwt_helper.php";

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data["username"], $data["email"], $data["password"])) {
    echo json_encode(["status" => "error", "message" => "Dados incompletos"]);
    exit;
}

$username = trim($data["username"]);
$email = trim($data["email"]);
$password = password_hash($data["password"], PASSWORD_BCRYPT);

try {
    // Inserir usuário com plano básico (id 1)
    $stmt = $pdo->prepare("INSERT INTO users (username, email, password, plan_id) VALUES (?, ?, ?, 1)");
    $stmt->execute([$username, $email, $password]);
    $user_id = $pdo->lastInsertId();

    // Gerar token JWT
    $token = create_jwt($user_id);

    echo json_encode([
        "status" => "success",
        "message" => "Usuário registrado com sucesso",
        "token" => $token
    ]);
} catch (PDOException $e) {
    error_log("Erro ao registrar usuário: " . $e->getMessage());
    echo json_encode(["status" => "error", "message" => "Erro: " . $e->getMessage()]);
}
?>
