<?php
header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/guest_session.php";

// Tentar obter usuário logado
$user_id = null;
$headers = getallheaders();
if (isset($headers['Authorization'])) {
    require_once "../helpers/jwt_helper.php";
    $user_id = require_auth(true); // opcional
}

// Se não tiver usuário logado, criar guest_id
$guest_id = null;
if (!$user_id) {
    $guest_id = get_guest_id();
}

$group = isset($_GET['group']) ? intval($_GET['group']) : null;

if (!$user_id && !$group) {
    $group = 1;
}

// compatibilidade
$group_id = $group;

if (!$group_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => "Parâmetro 'group' é obrigatório"]);
    exit;
}


try {
    if ($user_id !== null && $user_id > 0) {
        // Usuário logado → pega fase atual do banco
        $stmt = $pdo->prepare("SELECT current_group FROM users WHERE id = ? LIMIT 1");
        $stmt->execute([$user_id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            http_response_code(404);
            echo json_encode(["success" => false, "message" => "Usuário não encontrado"]);
            exit;
        }
        $group_id = intval($row["current_group"]);
    } else {
        // Guest → sessão temporária
        $guest_id = get_guest_id();
        if (!$group_id) {
            http_response_code(400);
            echo json_encode(["success" => false, "message" => "Parâmetro 'group' é obrigatório para convidados"]);
            exit;
        }
    }

    // Buscar até 4 perguntas do grupo
    $stmt = $pdo->prepare("
        SELECT id, question, option_a, option_b, option_c, option_d
        FROM questions
        WHERE group_id = ?
        ORDER BY id ASC
        LIMIT 4
    ");
    $stmt->execute([$group_id]);
    $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($questions) === 0) {
        http_response_code(404);
        echo json_encode(["success" => false, "message" => "Nenhuma questão encontrada para o grupo $group_id"]);
        exit;
    }

    echo json_encode([
        "success" => true,
        "mode" => ($user_id ? "user" : "guest"),
        "id" => ($user_id ?: $guest_id),
        "group" => $group_id,
        "count" => count($questions),
        "questions" => $questions
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Erro no servidor: " . $e->getMessage()]);
    exit;
}
