<?php

header("Content-Type: application/json");
require_once "../config/db.php";
require_once "../helpers/jwt_helper.php";

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data["email"], $data["password"])) {

    echo json_encode(["status" => "error", "message" => "Dados incompletos"]);
    exit;

}

$email = $data["email"];
$password = $data["password"];

$stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user && password_verify($password, $user["password"])) {

     $token = create_jwt($user['id']);

    echo json_encode([
        "status" => "success",
        "user" => [
            "id" => $token,
            "username" => $user["username"],
            "email" => $user["email"],
            "score" => $user["score"],
            "plan_id" => $user["plan_id"]
        ]
    ]);

} else {

    http_response_code(401);
    echo json_encode(["status" => "error", "message" => "Credenciais inválidas"]);
    
}
?>
