<?php
header("Content-Type: application/json");
require_once "../config/db.php"; // espera que $pdo (PDO) esteja disponível

// parâmetros opcionais
$period = isset($_GET['period']) ? strtolower($_GET['period']) : 'global';
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
if ($limit <= 0) $limit = 10;

$valid_periods = ['global', 'daily', 'weekly'];
if (!in_array($period, $valid_periods)) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Período inválido. Use global, daily ou weekly"]);
    exit;
}

try {
    // Query leaderboard para o período escolhido

    $stmt = $pdo->prepare("
    SELECT u.username, l.score, l.updated_at
    FROM leaderboards l
    JOIN users u ON l.user_id = u.id
    WHERE l.period = ?
    ORDER BY l.score DESC, l.updated_at ASC
    LIMIT ?
");
    $stmt->bindValue(1, $period, PDO::PARAM_STR);
    $stmt->bindValue(2, $limit, PDO::PARAM_INT);
    $stmt->execute();

    $leaders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Adicionar rank
    $ranked = [];
    $rank = 1;
    foreach ($leaders as $row) {
        $row['rank'] = $rank++;
        $ranked[] = $row;
    }

    echo json_encode([
        "success" => true,
        "period" => $period,
        "count" => count($ranked),
        "leaderboard" => $ranked
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Erro no servidor: " . $e->getMessage()]);
    exit;
}
